#ifndef MATRIX_MANGLE_H
#define MATRIX_MANGLE_H
/* Matrix conversion functions */
#include "max.h"
#include "rwcore.h"

//Convert the given matrix to Renderware's axis system,
//relative to the given node in MAX's scene heirarcy
//(Currently, for correcting Character Studio's silly axis system
//to be consistent with other objects in MAX,
//but who knows what other sillyness Kinetix has up their sleeve)
extern const Matrix3
ToRenderwareAxisSystem( const Matrix3 &theMatrix, INode *relativeToThisNode );

extern Matrix3
WorldSpaceMatrix();

extern RwMatrix *
Matrix3ToRwMatrix(Matrix3 maxMat, RwMatrix *rwMatrix);

#include "warnings.h"

void NegativeScaleCheck( INode *node, TimeValue when, WarningList &warningList );

//take a matrix and return only translation/rotation parts in a new matrix
//(various scalings, including negative ones, will be removed).
Matrix3
Uniform_Matrix(Matrix3 orig_cur_mat);

#endif
